
/**
 * Class for bank accounts supporting deposit, withdraw, and balance inquiry.
 * 
 * @author JP Vergara 
 * @version 1.0
 */
public class BankAccount
{
    // Each bank accountobject stores a balance
    private double balance;

    /**
     * Constructor for objects of class BankAccount
     */
    public BankAccount()
    {
        balance = 0;
    }

    /**
     * Constructor for objects of class BankAccount,
     * where an initial balanc is specified
     * 
     * @param initBal  initial balance
     */
    public BankAccount( double initBal)
    {
        balance = initBal;
    }

    /**
     * Deposits some amount into the account
     * 
     * @param amount  amount to be deposited
     */
    public void deposit( double amount )
    {
        double newBalance = balance + amount;
        balance = newBalance;
    }

    /**
     * Withdraws some amount from the account
     * 
     * @param amount  amount to be withdrawn
     */
    public void withdraw( double amount )
    {
        if ( amount <= balance )
        {
            double newBalance = balance - amount;
            balance = newBalance;
        }
        else
        {
            System.out.println( "Insufficient balance" );
        }
    }

    /**
     * Get the current balance
     * 
     * @return  current balance 
     */
    public double getBalance( )
    {
        return balance;
    }

}
