
/**
 * Class for a bank that manages two accounts.
 * 
 * @author JP Vergara 
 * @version 1.0
 */
public class Bank
{
   private BankAccount john;
   private BankAccount marsha;
   
   /*
    * Constructor for a Bank objects.
    * Two bank accounts are created with different balances.
    * 
    */
   public Bank()
   {
       john = new BankAccount( 1000.00 );
       marsha = new BankAccount( 2000.00 );
   }
   
   /*
    * Deposit some amount to the account with the given name
    * 
    * @param name   name of account to deposit to
    * @param amount amount to deposit
    * 
    */
   
   public void deposit( String name, double amount )
   {
       if ( name.equalsIgnoreCase( "john" ) )
       {
           john.deposit( amount );
       }
       else if ( name.equalsIgnoreCase( "marsha" ) )
       {
           marsha.deposit( amount );
       }
       else
       {
           System.out.println( "No account with that name" );
       }
   }

   /*
    * Withdraw some amount from the account with the given name
    * 
    * @param name   name of account to withdraw from
    * @param amount amount to withdraw
    * 
    */
   
   public void withdraw( String name, double amount )
   {
       if ( name.equalsIgnoreCase( "john" ) )
       {
           john.withdraw( amount );
       }
       else if ( name.equalsIgnoreCase( "marsha" ) )
       {
           marsha.withdraw( amount );
       }
       else
       {
           System.out.println( "No account with that name" );
       }
   }

   /*
    * Return the balance of the account with the given name
    * 
    * @param name   name of account
    * @return balamce
    * 
    */
   
   public double getBalance( String name )
   {
       if ( name.equalsIgnoreCase( "john" ) )
       {
           return john.getBalance();
       }
       else if ( name.equalsIgnoreCase( "marsha" ) )
       {
           return marsha.getBalance();
       }
       else
       {
           System.out.println( "No account with that name" );
           return 0;  // need to return something
       }
   }
   
}
